(function() {
  $(function() {
    var aboutOpen, adjust_clock_size, build_sun_spots, current_theme, percent_time, set_sun_size, set_theme, themes, time_output, toggle_theme, update_clock, update_sun_color_and_position;
    $('.about-text').hide();
    // VARS
    themes = ['sunset'];
    current_theme = 0;
    time_output = $('.clock .time span');
    // FUNCTIONS
    toggle_theme = function() {
      if (current_theme + 1 >= themes.length) {
        return set_theme(0);
      } else {
        return set_theme(current_theme + 1);
      }
    };
    set_theme = function(index) {
      $('.body').removeClass(themes[current_theme]);
      current_theme = index;
      return $('.body').addClass(themes[index]);
    };
    percent_time = function(fixed) {
      var h, m, s, seconds, time;
      time = new Date();
      h = time.getHours();
      m = time.getMinutes();
      s = time.getSeconds();
      seconds = s + (m * 60) + (h * 3600);
      return ((seconds / 86400) * 100).toFixed(fixed);
    };
    adjust_clock_size = function() {
      var fontValue, topValue;
      fontValue = $('.time').width() / 6;
      topValue = ($(window).height() / 2) - (fontValue / 1.6);
      return $('.time').css({
        fontSize: fontValue,
        top: topValue
      });
    };
    update_clock = function() {
      var pTime, percent;
      percent = percent_time(2);
      pTime = percent + "%";
      if (pTime !== time_output.text()) {
        time_output.text(pTime);
        return update_sun_color_and_position(percent);
      }
    };
    update_sun_color_and_position = function(percent) {
      var blue, clockTop, decimalPercent, hColor, red, reverseDecimalPercent, shadowColor, spotColor, tColor, timeDecimalPercent, timeLeftOffset;
      $('.sun-container').css({
        left: percent + '%'
      });
      decimalPercent = percent * 0.01;
      reverseDecimalPercent = 1 - decimalPercent;
      red = Math.round(255 * decimalPercent);
      blue = Math.round(255 * reverseDecimalPercent);
      timeDecimalPercent = decimalPercent + (0.13 * (1300 / $(window).width()));
      if (timeDecimalPercent > 1) {
        timeDecimalPercent = 1;
      }
      timeLeftOffset = ($(window).width() - 140) * timeDecimalPercent;
      hColor = `rgba(${red},0,${blue},0.7)`;
      tColor = `rgba(${red},0,${blue},1)`;
      if (decimalPercent > 0.6) {
        clockTop = -60 * decimalPercent;
        $('.clock').css({
          top: clockTop
        });
      }
      $('.time').css({
        color: tColor,
        left: timeLeftOffset
      });
      spotColor = `rgba(${red},0,${blue}, 0.3)`;
      shadowColor = `rgba(${red},0,${blue}, 0.3) 0 0 27px 18px`;
      return $('.sun-spot').css({
        backgroundColor: spotColor,
        boxShadow: shadowColor
      });
    };
    build_sun_spots = function(count) {
      var accounted, i, j, ref, results, sun;
      sun = $('.sun');
      accounted = 0;
      results = [];
      for (i = j = 1, ref = count; (1 <= ref ? j <= ref : j >= ref); i = 1 <= ref ? ++j : --j) {
        results.push(setTimeout(function() {
          var div_class, left_offset, relative_size, size;
          accounted++;
          if (accounted === count) {
            div_class = "sun-spot last";
          } else {
            div_class = "sun-spot number" + accounted;
          }
          relative_size = Math.floor(Math.random() * 101);
          relative_size = relative_size - Math.floor(Math.random() * relative_size);
          left_offset = Math.floor(Math.random() * 71);
          size = relative_size + '%';
          sun.append(`<div class=\"${div_class}\" style=\"width:${relative_size + 30}%; height:${size}; top:${(100 - relative_size) / 2}%;left:${((100 - relative_size) / 2) + (10 - left_offset)}%;\"></div>`);
          if (accounted === count) {
            $('.sun-spot.last').hide();
            $('.sun-spot.last').fadeIn(2000, function() {
              return $('.sun-spot.last').addClass('pulse');
            });
          }
          return update_sun_color_and_position(percent_time(2));
        }, i * (4000 / count)));
      }
      return results;
    };
    set_sun_size = function() {
      var sunHeight, sunWidth, wH, wW;
      wH = $(window).height();
      wW = $(window).width();
      sunWidth = wW / 6;
      sunHeight = sunWidth / 3;
      return $('.sun').css({
        top: -1 * (sunHeight / 2),
        left: -1 * (sunWidth / 2),
        width: sunWidth,
        height: sunHeight
      });
    };
    
    // INIT
    set_theme(current_theme);
    update_clock();
    // ACTIONS
    setInterval(function() {
      return update_clock();
    }, 200);
    $('.clock').click(function() {
      console.log('click');
      return toggle_theme();
    });
    aboutOpen = false;
    $('.about-btn').click(function(a) {
      var aboutBtn, aboutText, clockContainer, fadeSpeed;
      a.preventDefault();
      aboutBtn = $(this);
      clockContainer = $('.clock-sunset-container');
      aboutText = $('.about-text');
      fadeSpeed = 500;
      if (aboutOpen) {
        aboutOpen = false;
        aboutBtn.fadeOut(fadeSpeed, function() {
          aboutBtn.text('About');
          return aboutBtn.fadeIn(fadeSpeed);
        });
        return aboutText.fadeOut(fadeSpeed, function() {
          return clockContainer.animate({
            opacity: 1
          }, fadeSpeed);
        });
      } else {
        aboutOpen = true;
        aboutBtn.fadeOut(400, function() {
          aboutBtn.text('close');
          return aboutBtn.fadeIn(400);
        });
        return clockContainer.animate({
          opacity: 0
        }, fadeSpeed, function() {
          return aboutText.fadeIn(fadeSpeed);
        });
      }
    });
    build_sun_spots(28);
    set_sun_size();
    return $(window).resize(function() {
      set_sun_size();
      return update_sun_color_and_position(percent_time(2));
    });
  });

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
//# sourceURL=coffeescript